IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Vta_TCli_Prod_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Vta_TCli_Prod_Validar
END
GO

CREATE FUNCTION [dbo].[CF_Vta_TCli_Prod_Validar](@pId_Cliente INT, @pId_Producto VARCHAR(14))
RETURNS TINYINT
AS
BEGIN

DECLARE @Flag_Cliente_Valido					TINYINT -- Valor a retornar: 1 para inhabilitado, 0 para habilitado.
DECLARE @Flag_Prod_Valida_Cat					TINYINT -- Flag que chequea si el producto se valida por categorías.
DECLARE @Flag_Existe_Producto_Cat				TINYINT -- Flag que chequea si el producto esta disponible para la categoría del cliente.
DECLARE @Id_Tipo_Cli							INT		-- La categoría del cliente.

/*=================================================================================*/

SET @Id_Tipo_Cli = (SELECT DBO.SF_Categ(@pId_Cliente,GETDATE()))
SET @Flag_Cliente_Valido = 0

SET @Flag_Prod_Valida_Cat = ISNULL((SELECT TOP 1 1 FROM Clientes_Tipos_Prod tp, Clientes c 
											 WHERE tp.Id_Tipo_Cli=c.Id_Tipo_Cli 
											 AND tp.Id_Producto=@pId_Producto)
									         ,0)
IF(@Flag_Prod_Valida_Cat <> 0)
BEGIN
	SET @Flag_Existe_Producto_Cat = ISNULL((SELECT 1 FROM Clientes_Tipos_Prod tp, Clientes c 
													 WHERE tp.Id_Tipo_Cli=c.Id_Tipo_Cli 
													 AND tp.Id_Producto=@pId_Producto 
													 AND c.Id_Cliente=@pId_Cliente
													 AND tp.Id_Tipo_Cli = @Id_Tipo_Cli)
													 ,0)

	IF(@Flag_Existe_Producto_Cat <> 0)
	BEGIN
		SET @Flag_Cliente_Valido = 1
		RETURN ISNULL(@Flag_Cliente_Valido,0)
	END
END		

RETURN ISNULL(@Flag_Cliente_Valido,0) 	
END

